import type { SVGProps } from 'react';

interface CustomIconProps extends SVGProps<SVGSVGElement> {
    size?: number;
    fill?: string;
    stroke?: string;
    strokeWidth?: number;
    viewBox?: string;
}

const license = ({
                     size = 48,
                     fill = 'none',
                     stroke = 'none',
                     strokeWidth = 2,
                     viewBox = '0 0 48 48',
                     ...props
                 }: CustomIconProps) => (
    <svg
        width={size}
        height={size}
        fill={fill}
        stroke={stroke}
        strokeWidth={strokeWidth}
        viewBox={viewBox}
        strokeLinecap="round"
        strokeLinejoin="round"
        xmlns="http://www.w3.org/2000/svg"
        {...props}
    >
        <path
            d="M10 40C8.9 40 7.95833 39.6083 7.175 38.825C6.39167 38.0417 6 37.1 6 36V34.4C6 33.2667 6.29167 32.225 6.875 31.275C7.45833 30.325 8.23333 29.6 9.2 29.1C11.2667 28.0667 13.3667 27.2917 15.5 26.775C17.6333 26.2583 19.8 26 22 26C22.4667 26 22.9333 26.0083 23.4 26.025C23.8667 26.0417 24.3333 26.0833 24.8 26.15C25.1667 26.1833 25.4583 26.325 25.675 26.575C25.8917 26.825 26 27.1333 26 27.5C26.0667 29.0667 26.45 30.5417 27.15 31.925C27.85 33.3083 28.7833 34.4833 29.95 35.45C30.1833 35.6167 30.3667 35.825 30.5 36.075C30.6333 36.325 30.7 36.6 30.7 36.9V38C30.7 38.5667 30.5083 39.0417 30.125 39.425C29.7417 39.8083 29.2667 40 28.7 40H10ZM22 24C19.8 24 17.9167 23.2167 16.35 21.65C14.7833 20.0833 14 18.2 14 16C14 13.8 14.7833 11.9167 16.35 10.35C17.9167 8.78333 19.8 8 22 8C24.2 8 26.0833 8.78333 27.65 10.35C29.2167 11.9167 30 13.8 30 16C30 18.2 29.2167 20.0833 27.65 21.65C26.0833 23.2167 24.2 24 22 24ZM37 28C37.5667 28 38.0417 27.8083 38.425 27.425C38.8083 27.0417 39 26.5667 39 26C39 25.4333 38.8083 24.9583 38.425 24.575C38.0417 24.1917 37.5667 24 37 24C36.4333 24 35.9583 24.1917 35.575 24.575C35.1917 24.9583 35 25.4333 35 26C35 26.5667 35.1917 27.0417 35.575 27.425C35.9583 27.8083 36.4333 28 37 28ZM37.3 45.3L35.3 43.3C35.2333 43.2333 35.1333 43 35 42.6V33.7C33.5333 33.2667 32.3333 32.4417 31.4 31.225C30.4667 30.0083 30 28.6 30 27C30 25.0667 30.6833 23.4167 32.05 22.05C33.4167 20.6833 35.0667 20 37 20C38.9333 20 40.5833 20.6833 41.95 22.05C43.3167 23.4167 44 25.0667 44 27C44 28.5 43.575 29.8333 42.725 31C41.875 32.1667 40.8 33 39.5 33.5L41.3 35.3C41.5 35.5 41.6 35.7333 41.6 36C41.6 36.2667 41.5 36.5 41.3 36.7L39.7 38.3C39.5 38.5 39.4 38.7333 39.4 39C39.4 39.2667 39.5 39.5 39.7 39.7L41.3 41.3C41.5 41.5 41.6 41.7333 41.6 42C41.6 42.2667 41.5 42.5 41.3 42.7L38.7 45.3C38.5 45.5 38.2667 45.6 38 45.6C37.7333 45.6 37.5 45.5 37.3 45.3Z"
            fill={fill}
            stroke={stroke}
            strokeWidth={strokeWidth}
        />
    </svg>
);

export default license;